from sqlalchemy.orm import Session
from app.models.user_log import UserLog
from typing import Optional, Dict, Any
import uuid


def log_user_action(
    db: Session,
    user_id: int,
    action: str,
    details: Optional[Dict[str, Any]] = None,
    ip_address: Optional[str] = None
) -> uuid.UUID:
    transaction_id = uuid.uuid4()
    
    user_log = UserLog(
        transaction_id=transaction_id,
        user_id=user_id,
        action=action,
        details=details,
        ip_address=ip_address
    )
    
    db.add(user_log)
    db.commit()
    db.refresh(user_log)
    
    return transaction_id