from sqlalchemy.orm import Session
from sqlalchemy import select
from app.models.user import User
from app.models.user_log import UserLog
from app.schemas.user_log import UserLogResponse
from typing import List


class UserService:
    def __init__(self, db: Session):
        self.db = db

    def get_user_by_id(self, user_id: int) -> User:
        return self.db.execute(select(User).where(User.id == user_id)).scalar_one_or_none()

    def get_user_logs(self, user_id: int, limit: int = 50, offset: int = 0) -> List[UserLogResponse]:
        result = self.db.execute(
            select(UserLog)
            .where(UserLog.user_id == user_id)
            .order_by(UserLog.timestamp.desc())
            .limit(limit)
            .offset(offset)
        )
        logs = result.scalars().all()
        return [UserLogResponse.from_orm(log) for log in logs]