from pydantic import BaseModel
from datetime import datetime
from typing import Optional, Dict, Any
import uuid


class UserLogResponse(BaseModel):
    id: int
    transaction_id: uuid.UUID
    user_id: int
    action: str
    details: Optional[Dict[str, Any]]
    ip_address: Optional[str]
    timestamp: datetime

    class Config:
        from_attributes = True