from pydantic import BaseModel
from typing import List
import uuid


class FaceBox(BaseModel):
    x: int
    y: int
    width: int
    height: int
    confidence: float


class FaceDetectionResponse(BaseModel):
    transaction_id: uuid.UUID
    face_count: int
    faces: List[FaceBox]
    success: bool
    message: str