from sqlalchemy import create_engine
from sqlalchemy.orm import DeclarativeBase, sessionmaker, Session
from app.config import settings


class Base(DeclarativeBase):
    pass

engine = create_engine(
    settings.database_url,
    echo=True,
)

SessionLocal = sessionmaker(
    bind=engine,
    autocommit=False,
    autoflush=False,
)


def get_db():
    db = SessionLocal() # Session oluştur
    try:
        yield db   # Endpoint çalışırken bekle
    finally:
        db.close()  # Tamamlandığında kapat (hata olsa bile kapanır)