from pydantic_settings import BaseSettings
from typing import Optional


class Settings(BaseSettings):
    database_url: str
    jwt_secret_key: str
    jwt_algorithm: str = "HS256"
    access_token_expire_minutes: int = 30
    yunet_model_path: str = "models/yunet_model.onnx"
    max_file_size: int = 10485760  # 10MB
    allowed_extensions: str = "jpg,jpeg,png"
    
    class Config:
        env_file = ".env"


settings = Settings()